package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.RegimenJuridico;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * RegimenJuridicoDaoImpl generated by UDA, 27-sep-2016 13:26:09.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class RegimenJuridicoDaoImpl implements RegimenJuridicoDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RegimenJuridico> rwMap = new RowMapper<RegimenJuridico>() {
		public RegimenJuridico mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new RegimenJuridico(resultSet.getString("REGI005"),
					resultSet.getString("DESC005"),
					resultSet.getString("CODFSE005"));
		}
	};

	private RowMapper<RegimenJuridico> rwMapPK = new RowMapper<RegimenJuridico>() {
		public RegimenJuridico mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new RegimenJuridico(resultSet.getString("REGI005"),
					resultSet.getString("DESC005"),
					resultSet.getString("CODFSE005"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the RegimenJuridico table.
	 * 
	 *  regimenjuridico
	 *            RegimenJuridico
	 *  RegimenJuridico
	 *
	 * @param regimenjuridico the regimenjuridico
	 * @return the regimen juridico
	 */
	public RegimenJuridico add(RegimenJuridico regimenjuridico) {
		String query = "INSERT INTO J7305S00 (REGI_005, DESC_005, CODFSE_005) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, regimenjuridico.getRegi005(),
				regimenjuridico.getDesc005(), regimenjuridico.getCodfse005());
		return regimenjuridico;
	}

	/**
	 * Updates a single row in the RegimenJuridico table.
	 * 
	 *  regimenjuridico
	 *            RegimenJuridico
	 *  RegimenJuridico
	 *
	 * @param regimenjuridico the regimenjuridico
	 * @return the regimen juridico
	 */
	public RegimenJuridico update(RegimenJuridico regimenjuridico) {
		String query = "UPDATE J7305S00 SET  WHERE REGI_005=? AND DESC_005=? AND CODFSE_005=?";
		this.jdbcTemplate.update(query, regimenjuridico.getRegi005(),
				regimenjuridico.getDesc005(), regimenjuridico.getCodfse005());
		return regimenjuridico;
	}

	/**
	 * Finds a single row in the RegimenJuridico table.
	 * 
	 *  regimenjuridico
	 *            RegimenJuridico
	 *  RegimenJuridico
	 *
	 * @param regimenjuridico the regimenjuridico
	 * @return the regimen juridico
	 */
	@Transactional(readOnly = true)
	public RegimenJuridico find(RegimenJuridico regimenjuridico) {
		String query = "SELECT t1.REGI_005 REGI005, t1.DESC_005 DESC005, t1.CODFSE_005 CODFSE005 FROM J7305S00 t1  WHERE t1.REGI_005 = ?   AND t1.DESC_005 = ?   AND t1.CODFSE_005 = ?  ";

		List<RegimenJuridico> regimenjuridicoList = this.jdbcTemplate.query(
				query, this.rwMap, regimenjuridico.getRegi005(),
				regimenjuridico.getDesc005(), regimenjuridico.getCodfse005());
		return (RegimenJuridico) DataAccessUtils
				.uniqueResult(regimenjuridicoList);
	}

	/**
	 * Removes a single row in the RegimenJuridico table.
	 * 
	 *  regimenjuridico            RegimenJuridico
	 *
	 * @param regimenjuridico the regimenjuridico
	 */
	public void remove(RegimenJuridico regimenjuridico) {
		String query = "DELETE FROM J7305S00 WHERE REGI_005=? AND DESC_005=? AND CODFSE_005=?";
		this.jdbcTemplate.update(query, regimenjuridico.getRegi005(),
				regimenjuridico.getDesc005(), regimenjuridico.getCodfse005());
	}

	/**
	 * Finds a list of rows in the RegimenJuridico table.
	 * 
	 *  regimenjuridico
	 *            RegimenJuridico
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<RegimenJuridico>
	 *
	 * @param regimenjuridico the regimenjuridico
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<RegimenJuridico> findAll(RegimenJuridico regimenjuridico,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.REGI_005 REGI005,t1.DESC_005 DESC005,t1.CODFSE_005 CODFSE005 ");
		query.append("FROM J7305S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(regimenjuridico);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<RegimenJuridico>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the RegimenJuridico table using like.
	 * 
	 *  regimenjuridico
	 *            RegimenJuridico
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<RegimenJuridico>
	 *
	 * @param regimenjuridico the regimenjuridico
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<RegimenJuridico> findAllLike(RegimenJuridico regimenjuridico,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.REGI_005 REGI005,t1.DESC_005 DESC005,t1.CODFSE_005 CODFSE005 ");
		query.append("FROM J7305S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(regimenjuridico,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<RegimenJuridico>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the RegimenJuridico table.
	 * 
	 *  regimenjuridico
	 *            RegimenJuridico
	 *  Long
	 *
	 * @param regimenjuridico the regimenjuridico
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(RegimenJuridico regimenjuridico) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM J7305S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(regimenjuridico);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the RegimenJuridico table using like.
	 * 
	 *  regimenjuridico
	 *            RegimenJuridico
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param regimenjuridico the regimenjuridico
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(RegimenJuridico regimenjuridico,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM J7305S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(regimenjuridico,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of RegimenJuridico selected for rup_table.
	 * 
	 *  regimenjuridico            RegimenJuridico
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<RegimenJuridico>>
	 *
	 * @param regimenjuridico the regimenjuridico
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<RegimenJuridico>> reorderSelection(
			RegimenJuridico regimenjuridico, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.REGI_005 REGI005,t1.DESC_005 DESC005,t1.CODFSE_005 CODFSE005 ");
		// FROM
		query.append("FROM J7305S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(regimenjuridico,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, RegimenJuridico.class,
				filterParamList, "REGI_005,DESC_005,CODFSE_005");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<RegimenJuridico>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the RegimenJuridico entity.
	 * 
	 *  regimenjuridico            RegimenJuridico Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param regimenjuridico the regimenjuridico
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(RegimenJuridico regimenjuridico) {

		StringBuilder where = new StringBuilder(
				RegimenJuridicoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (regimenjuridico != null && regimenjuridico.getRegi005() != null) {
			where.append(" AND t1.REGI_005 = ?");
			params.add(regimenjuridico.getRegi005());
		}
		if (regimenjuridico != null && regimenjuridico.getDesc005() != null) {
			where.append(" AND t1.DESC_005 = ?");
			params.add(regimenjuridico.getDesc005());
		}
		if (regimenjuridico != null && regimenjuridico.getCodfse005() != null) {
			where.append(" AND t1.CODFSE_005 = ?");
			params.add(regimenjuridico.getCodfse005());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the RegimenJuridico entity.
	 * 
	 *  regimenjuridico            RegimenJuridico Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param regimenjuridico the regimenjuridico
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(
			RegimenJuridico regimenjuridico, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				RegimenJuridicoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (regimenjuridico != null && regimenjuridico.getRegi005() != null) {
			where.append(" AND UPPER(t1.REGI_005) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(regimenjuridico.getRegi005().toUpperCase() + "%");
			} else {
				params.add("%" + regimenjuridico.getRegi005().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.REGI_005 IS NOT NULL");
		}
		if (regimenjuridico != null && regimenjuridico.getDesc005() != null) {
			where.append(" AND UPPER(t1.DESC_005) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(regimenjuridico.getDesc005().toUpperCase() + "%");
			} else {
				params.add("%" + regimenjuridico.getDesc005().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESC_005 IS NOT NULL");
		}
		if (regimenjuridico != null && regimenjuridico.getCodfse005() != null) {
			where.append(" AND UPPER(t1.CODFSE_005) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(regimenjuridico.getCodfse005().toUpperCase() + "%");
			} else {
				params.add("%" + regimenjuridico.getCodfse005().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CODFSE_005 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
